var db = null;
var DBNAME = "orders";
var DBVER = 3;
var keyPath;



document.addEventListener("DOMContentLoaded", function() {
 displayMenu();
 openDB();
 },false);


// Check if new or existing customer
document.getElementById('email').onblur = function(e) {
  keyPath = document.getElementById('email').value;
  checkCusotmerStatusByKeyPath(e, keyPath);
  displayOrder(e, keyPath);
}





// Display menu
var menu;
function displayMenu() {
  console.log('display menu');
	menu = {'slice of pizza':1.99,'sandwich':5.99,'salad':3.99,'french fries':1.99,'soda':1.99};
	var table = document.getElementById('menuTable');
  table.insertRow(0).innerHTML =
    '<tr>' +
      '<th>Item</th>' +
      '<th>Price</th>' +
      '<th>Quantity</th>' +
    '</tr>';
	var menuKeys = Object.keys(menu);
  for (var i = menuKeys.length-1; i >= 0; i--) {
    var key = menuKeys[i];
    var value = menu[key];
    var rows = table.insertRow(1);
    rows.innerHTML +=
        '<tr>' +
          '<td>' + key + '</td>' +
          '<td id="' + key + 'price' + '">' + '$' + value + '</td>' +
          '<td><input type="number" name="quantity" id="' + key + '"></td>' +
          '<td><input type="button" id="' + 'update' + key + '" value="Add" onclick="updateByKeyPath(keyPath,&quot;' + key + '&quot;);">' +
            '<span id="' + 'delete' + key + '"></span></td>' +
        '</tr>'
	}

}







function displayOrder(e, keyPath) {
  console.log("keyPath: " + keyPath);
  var tx = db.transaction(["customers"], "readonly");
  var store = tx.objectStore("customers");
  var request = store.get(keyPath);
  request.onsuccess = function(e) {
    console.log('display order');
    var menuKeys = Object.keys(menu);
    for (var i = menuKeys.length-1; i >= 0; i--) {
      document.getElementById(menuKeys[i]).value = '';
      document.getElementById('update' + menuKeys[i]).value = "Add";
      document.getElementById('delete' + menuKeys[i]).innerHTML = '';
    }
    var table = document.getElementById('orderTable');
    if (e.target.result) {
      var orderData = e.target.result;
      var keys = Object.keys(orderData);
      var orderTotalRow = keys.length + 1;
      var total = 0;
      var orderTotal = 0;
      var roundedOrderTotal = 0;
      document.getElementById('orderSummary').innerHTML = "<hr><h2>Order Summary:</h2>";
      table.innerHTML = "";
      table.insertRow(0).innerHTML =
        '<tr>' +
          '<td>' + keys[0] + ':</td>' +
          '<td colspan="3">' + orderData[keys[0]] + '</td>' +
          '<td>' +
        '</tr>';
      table.insertRow(1).innerHTML =
        '<tr>' +
          '<td>' + keys[1] + ':</td>' +
          '<td colspan="3">' + orderData[keys[1]] + '</td>' +
          '<td>' +
        '</tr>';
      table.insertRow(2).innerHTML =
        '<tr>' +
          '<th>Item</td>' +
          '<th>Price</td>' +
          '<th>Quantity</td>' +
          '<th>Total</td>' +
          '<th>' +
        '</tr>';

      for (var i = keys.length-1; i >= 2; i--) {
        var key = keys[i];
        var value = orderData[key];
        orderQty = value;
        console.log(orderQty);
        document.getElementById(key).value = orderQty;
        document.getElementById('update' + key).value = "Update";
        document.getElementById('delete' + key).innerHTML = '<button id="' + 'delete' + key + '" onclick="deleteByKeyPath(keyPath,&quot;' + key + '&quot;);">Delete</button>';
        var dirtyprice = document.getElementById(key + "price").innerHTML;
        var cleanprice = dirtyprice.replace('$', '')
        var price = Number(cleanprice);
        console.log('price ' + price);
        var qty = document.getElementById(key).value;
        console.log('qty ' + qty);
        total = price * qty;
        console.log("Total: " + total);
        var roundedTotal = total.toFixed(2);
        orderTotal += total;
        console.log('OrderTotal: ' + orderTotal);
        roundedOrderTotal = orderTotal.toFixed(2);
        console.log(key + ": " + orderData[key]);
        table.insertRow(3).innerHTML =
          '<tr>' +
            '<td>' + key + ':</td>' +
            '<td>' + '$' + price + '</td>' +
            '<td id="' + key + 'qty' + '">' + value + '</td>' +
            '<td>' + '$' + roundedTotal +
          '</tr>';
      }
      table.insertRow(orderTotalRow).innerHTML =
        '<tr>' +
          '<th colspan="3">Total</td>' +
          '<th>' + '$' + roundedOrderTotal + '</td>' +
        '</tr>';
    }
  }
  document.getElementById('orderSummary').innerHTML = "";
  document.getElementById('orderTable').innerHTML = "";
}





function openDB() {
  var request = indexedDB.open(DBNAME, DBVER);
  request.onupgradeneeded = function(e) {
    console.log("Upgrading...");
    var thisDB = e.target.result;
    var store = null;
    if (!thisDB.objectStoreNames.contains("customers")) {
      store = thisDB.createObjectStore("customers", {
        keyPath: "email"
      });
    }
  };
  request.onsuccess = function (e) {
    console.log("openDB success!");
    db = e.target.result;
  };
  request.onerror = function (e) {
    console.log("openDB error");
  };
}






function addCustomer(o) {
  console.log(o);
  var tx = db.transaction(["customers"], "readwrite");
  var store = tx.objectStore("customers");
  o.created = new Date();
  var request = store.add(o);
  request.onsuccess = function(e) {
    console.log("Add 'customer' successful! person=" + JSON.stringify(o));
  };
  request.onerror = function(e) {
    console.log("Add error", e.target.error.name);
  };
}






function checkCusotmerStatusByKeyPath(e, keyPath) {
  console.log("keyPath: " + keyPath);
  var tx = db.transaction(["customers"], "readonly");
  var store = tx.objectStore("customers");
  var request = store.get(keyPath);
  request.onsuccess = function(e) {
    console.log(e.target.result);
    if (e.target.result) {
      document.getElementById('customerStatus').innerHTML = 'Welcome back!';
    } else {
      var email = keyPath;
      addCustomer({email: email});
      document.getElementById('customerStatus').innerHTML = 'Welcome, your account has been created';
    }
  }
  request.onerror = function(e) {
    console.log('failure to make find customer request to database');
  }
}






function deleteByKeyPath(keyPath, property) {
  console.log("deleting property: " + property + " from KeyPath: " + keyPath);
  var tx = db.transaction(["customers"], "readwrite");
  var store = tx.objectStore("customers");
  store.get(keyPath).onsuccess = function(e) {
    console.log("store.get", keyPath);
    var data = e.target.result;
    if (!data) {
      console.log("nothing matched.");
      return;
    }
    delete data[property];
    var request = store.put(data);
    request.onsuccess = function(e) {
      console.log("put success!");
    };
    request.onerror = function(e) {
      console.log("put error!");
    };
    document.getElementById(property).value = "";
    console.log(data);
    console.log('update' + property);
    document.getElementById('update' + property).value = "Add";
    document.getElementById('delete' + property).innerHTML = '';
    displayOrder(e, keyPath);
  };
}






function updateByKeyPath(keyPath, property) {
  console.log("KeyPath: " + keyPath + ", Property: " + property);
  var tx = db.transaction(["customers"], "readwrite");
  var store = tx.objectStore("customers");
  store.get(keyPath).onsuccess = function(e) {
    console.log("store.get", keyPath);
    var data = e.target.result;
    if (!data) {
      console.log("nothing matched.");
      return;
    }
    data[property] = document.getElementById(property).value
    var request = store.put(data);
    request.onsuccess = function(e) {
      console.log("put success!");
    };
    request.onerror = function(e) {
      console.log("put error!");
    };
    console.log(e.target.result);
    console.log('update' + property);
    document.getElementById('update' + property).value = "Update";
    document.getElementById('delete' + property).innerHTML = '<button id="' + 'delete' + property + '" onclick="deleteByKeyPath(keyPath,&quot;' + property + '&quot;);">Delete</button>';
    displayOrder(e, keyPath);
  };
}
